/******************************************************************************
* This public header file provides structure definition for different table
* structure whose size can be configured by the application.
*
* Copyright (c) 2008, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*******************************************************************************/

#ifndef _FSL_PROFILE_GLOBALS_H_
#define _FSL_PROFILE_GLOBALS_H_

#include "NwkGlobals.h"
#include "FSLProfileInterface.h"


/******************************************************************************
*******************************************************************************
* Public macros
*******************************************************************************
******************************************************************************/

/*******************************************************************************
********************************************************************************
* Public prototypes
********************************************************************************
*******************************************************************************/


/****************************************************************************
*****************************************************************************
* Public type definitions
*****************************************************************************
****************************************************************************/

/****************************************************************************
*****************************************************************************
* Public memory declarations
*****************************************************************************
****************************************************************************/
/* The Task Id for FSL Profile */
extern tsTaskID_t gFSLProfileTaskID_c;


/* ----  FragTx Orig and Recip related -----  */

/* FragTxRx buffer length */
extern CONST uint16_t fragTxRxBufferLength_c;

/* FragTxRx data buffer */
extern uint8_t fragTxRxDataBuffer[];


/* ------- Menu Displayer module related variables ------- */

/* To be declared in FSLProfileGlobals.c file and initialized with the value
of the gMaxMenuEntriesToDisplay_c define.
   Stores the maximum number of entries of a menu that can be displayed on the GUI
of the displayer device */
extern uint8_t gMaxMenuEntriesToDisplay;


/* Otap client related variables */
extern uint8_t 			gOtapClientDownloadImageStatus;
extern CONST uint16_t 	gOtapClientWaitRespTimeout;
extern CONST uint8_t  	gOtapClientMaxRetries;
/****************************************************************************
*****************************************************************************
* Public functions
*****************************************************************************
****************************************************************************/
/* The Task for FSL Profile and profile initialization */
extern void FSLProfile_MainTask(event_t events);
extern void FSLProfile_Init(void);

#endif /* _FSL_PROFILE_GLOBALS_H_ */
